<?php
/**
 * Core file.
 *
 * @author Vince Wooll <sales@jomres.net>
 *
 * @version Jomres 9.21.3
 *
 * @copyright	2005-2020 Vince Wooll
 * Translation to fr-FR by Stéphane Bernard, Valtari NumAgency, France - 14/06/2019 - https://www.valtari.fr
 * Jomres is currently available for use in all personal or commercial projects under both MIT and GPL2 licenses. This means that you can choose the license that best suits your project, and use it accordingly
 **/
//#################################################################
defined('_JOMRES_INITCHECK') or die('Direct Access to this file is not allowed.');
//#################################################################
/**
 *
 * @package Jomres\Core\Languages
 *
 * Language files.
 *
 **/
jr_define('_JOMRES_FAQ', 'FAQ (Questions Fréquemment Posées)');
jr_define('_JOMRES_FAQ_ADMIN_CATEGORY_INTRODUCTION', 'Introduction');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_INTRODUCTION_WHATISJOMRES', 'Qu\'est-ce que le logiciel Jomres ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_INTRODUCTION_WHATISJOMRES', 'Jomres est un système de réservation d\'hôtels et de villas/maisons/gîtes/villages fonctionnant avec les systèmes de gestion de contenu Joomla et Wordpress. C\'est un système de réservation complet, comme booking.com ou airbnb sans les frais d\'abonnements et/ou de commisions. C\'est une boîte à outils complète qui vous permet de créer un service de réservation en ligne unique pour autant de types d\'établissements que vous souhaitez.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_INTRODUCTION_USERSADD', 'Les utilisateurs peuvent-ils s\'inscrire sur mon site de réservation et ajouter leurs propres établissements ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_INTRODUCTION_USERSADD', 'Oui. Par défaut, Jomres permet aux utilisateurs enregistrés d’ajouter leurs propres établissements à votre site. Vous pouvez le désactiver dans l\'onglet Configuration du site> Divers, si vous en avez besoin.');
jr_define('_JOMRES_FAQ_ADMIN_CATEGORY_PROPERTIES', 'Établissements');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_ADDPROPERTIES', 'Comment puis-je ajouter un nouvel établissement ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_ADDPROPERTIES', 'Lorsque Jomres est installé, l\'administrateur est créé en tant que Super Property Manager (super administrateur d\'établissements). Connectez-vous sur le site en tant qu\'administrateur et à partir de là, vous pourrez ajouter de nouveaux établissements. <br/> Vous pouvez créer de nouveaux gestionnaires dans la page Gestionnaires d\'établissements. Toutefois, par défaut (mais vous pouvez le désactiver), tout utilisateur enregistré qui crée un établissement est automatiquement classé en tant que gestionnaire d\'établissements (partenaires) pour ceux qu\'il a créés. Pour des raisons de sécurité, ils ne peuvent pas administrer les établissements des autres gestionnaires. Cela peut être modifié en classant cet utilisateur en un super administrateur d\'établissements dans la page Gestionnaires d\'établissements.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_IMPORTPROPERTIES', 'Puis-je importer des établissements d\'un autre système ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_IMPORTPROPERTIES', 'Vous pouvez importer des établissements de plusieurs manières. Le plug-in Property Import (import d\'établissements) vous permet d\'importer des établissements via un fichier CSV. Cela vous permet d\'importer plusieurs établissements à la fois, mais il s\'agit d\'une fonctionnalité réservée aux administrateurs avertis. Si le gestionnaire d\'établissement a un compte Beds24, il peut importer toutes les hébergements existantes de son compte une fois les clés API liées. Une autre méthode consiste à utiliser l\'API. Il existe une fonctionnalité permettant d\'ajouter et de supprimer des établissements. Toutefois, vous devez être un développeur familiarisé avec l\'utilisation des API REST (REST APIs) pour utiliser cette fonctionnalité.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_IMPORTBOOKINGS', 'Puis-je importer des réservations d\'un autre système ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_IMPORTBOOKINGS', 'Les réservations peuvent être importées dans un établissement par un gestionnaire d\'établlsiements via le plug-in iCal, qui offre une fonctionnalité permettant d\'importer des réservations dans le menu du gestionnaire d\'établissements. En outre, si un administrateur de biens a un compte Beds24 et que son établissement a été connectée à Beds24, il peut alors effectuer une action de renvoi/notification des réservations dans Beds24.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_EMAILTEMPLATES', 'Puis-je modifier des templates (modèles) de courrier électronique ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_EMAILTEMPLATES', 'Les gestionnaires d\'établissements peuvent modifier les modèles de mail via leur barre d\'outils à Paramètres > Template de mails.');
jr_define('_JOMRES_FAQ_ADMIN_CATEGORY_PAYMENTS', 'Paiements');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_TAKEPAYMENTS', 'Comment permettre aux établissements d\'accepter des paiements ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_TAKEPAYMENTS', 'Vous devrez installer une passerelle de paiement. Jomres dispose de deux passerelles de paiements qui se connectent à Paypal ou à Stripe. Il propose également deux passerelles de paiements Offline (hors ligne) et vous pouvez acheter d’autres passerelles de paiements auprès de nos partenaires.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_WHICHGATEWAY', 'Quelle passerelle de paiements devrais-je utiliser ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_WHICHGATEWAY', 'Si vous souhaitez utiliser un pourcentage pour les acomptes qui correspondent à vos propres frais, utilisez la passerelle Stripe. Si vous ne le faites pas et souhaitez utiliser la fonctionnalité Abonnement et/ou Commission, vous devrez utiliser la passerelle Paypal.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_PAYMENTACCOUNTS', 'Qui reçoit l\'argent lorsqu\'un client effectue un paiement pour une réservation ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_PAYMENTACCOUNTS', 'Cela dépend de la manière dont vous avez configuré les passerelles de paiements sur votre site. Si vous utilisez Paypal, vous pouvez le configurer pour remplacer tous les paramètres des partenaires (gestionaires d\'établissements), en faisant de votre compte le seul compte qui reçoit des paiements. Si vous ne choisissez pas cette option, chaque établissement devra configurer son compte de passerelle de paiement dans l\'onglet Paramètres> Passerelles. Si vous utilisez Stripe, une fois que le gestionnaire d\'établissements a connecté son compte au vôtre (voir la documentation de Stripe dans le manuel pour plus d\'informations), il recevra tous les fonds, moins des frais de commission que vous pouvez configurer.');
jr_define('_JOMRES_FAQ_ADMIN_CATEGORY_TROUBLESHOOTING', 'Dépannage - Gestion des erreurs');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_TROUBLESHOOTING_EMAIL', 'Les mails de réservation ne sont pas envoyés.');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_TROUBLESHOOTING_EMAIL', 'Si vous rencontrez des problèmes pour envoyer des mails à partir du système, veuillez vérifier les paramètres de messagerie de votre hébergeur ou de votre serveur. Jomres utilise les paramètres Wordpress ou Joomla pour envoyer des mails. S\'ils sont mal configurés, Jomres ne pourra pas envoyer de mails.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_TROUBLESHOOTING_NOGATEWAY', 'La passerelle de paiement ne s\'affiche pas après avoir effectué une réservation.');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_TROUBLESHOOTING_NOGATEWAY', 'Si vous êtes connecté en tant que gestionnaire d\'établissement (partenaires), vous ne pouvez pas voir la passerelle de paiement, car vous n\'êtes pas le client qui paye ! Seuls les utilisateurs non-gestionnaires (clients) verront la passerelle lors de la réservation.');
jr_define('_JOMRES_FAQ_ADMIN_CATEGORY_PURCHASINGJOMRES', 'Licence Jomres');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_PURCHASINGJOMRES_FORCEDTOSUBSCRIBE', 'Après l\'achat de la licence initiale, suis-je obligé d\'acheter une licence de renouvellement une fois celle-ci expirée ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_PURCHASINGJOMRES_FORCEDTOSUBSCRIBE', 'Non, si vous avez acheté une licence Starter, Business ou Enterprise, vous pouvez continuer à utiliser le logiciel indéfiniment. Toutefois si vous contractez un abonnement. Une fois un abonnement annulé, vous ne pourrez plus utiliser les plugins et vous devrez les désinstaller.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_PURCHASINGJOMRES_EXPIRED', 'Ma licence a expiré. Puis-je quand même mettre à niveau Jomres ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_PURCHASINGJOMRES_EXPIRED', 'Bien que cela soit faisable en théorie, nous ne le recommandons pas ! Car une fois la licence expirée, vous ne pourrez plus bénéficier de l\’assistance, ni télécharger les mises à jour vers les plugins. Cela signifie que vous ne devriez  pas </ i> mettre à niveau votre installation de Jomres après l\’expiration de la licence. Cela est dû au fait que les plugins doivent être mis à jour régulièrement pour fonctionner avec les versions actuelles du système. Par conséquent, vos anciens plugins ne fonctionneront certainement pas avec une version plus récente du système. Si vous souhaitez toujours effectuer une mise à niveau pour tirer parti des nouvelles fonctionnalités, vous devez acheter une licence de renouvellement, qui est en réalité une licence normale avec une réduction de 50%.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_PURCHASINGJOMRES_SOFTWARELICENSE', 'Sous quelle type de licence logicielle Jomres est-il publié ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_PURCHASINGJOMRES_SOFTWARELICENSE', 'Jomres est sous licence MIT et GPL. Les plugins téléchargés avec les licences Starter, Business et Enterprise sont distribués sous la même licence et sont entièrement gratuits et à code source ouvert. Les plugins téléchargés pour les licences d\'essai et d\'abonnement ne sont pas publiés sous les licences GPL ou MIT et sont codés sous Ioncube. Cette approche nous permet de vous offrir une variété de licences différentes pour convenir à tout le monde.');
jr_define('_JOMRES_FAQ_MANAGER_CATEGORY_PROPERTY', 'Établissements');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_CREATPROPERTY', 'Comment créer un établissement ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_CREATPROPERTY', 'Cliquez sur Établissements > Nouvel établissement pour ajouter une nouvel établissement.');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_PREVIEW', 'Comment puis-je voir à quoi ressemble mon établissement pour les clients/internautes ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_PREVIEW', 'Cliquez sur Établissement > Aperçu/Prévisualisation pour voir à quoi ressemble votre établissement pour les clients.');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_ADDROOMS_MRP', 'Comment puis-je ajouter des chambres ? ');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_ADDROOMS_MRP', 'La façon dont vous ajoutez des chambres/hébergements dépend de votre mode d’édition des tarifs. En mode normal de modification du tarif, vous n\'avez pas besoin d\'ajouter de chambres, car elles sont automatiquement ajoutées lors de la configuration de vos prix. Si vous utilisez le mode de modification du tarif Micromanage ou Avancé, vous pouvez ajouter, modifier et supprimer des chambres dans Paramètres > Chambres. Vous pourrez également créer des équipements de chambres et les affecter à ces chambres. De plus, vous pourrez télécharger des images pour les chambres à l\'aide de Gestionnaire de médias. Lorsque vous créez des chambres, vous devez vous assurer que celles-ci reflètent bien la réalité des équipements, car elles seront ainsi plus faciles à gérer et à identifier.');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_ADDPRICES', 'Comment renseigner les prix des chambres ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_ADDPRICES', 'Cela dépend de votre mode d\’édition des tarifs. Si vous utilisez le mode normal de modification du tarif (onglet Configuration des établissements > Modes de modification du tarif), vous pouvez configurer le nombre de chambres dont vous disposez, le prix, le nombre de personnes que chaque chambre peut accueillir et le nombre total de personnes que vous souhaitez dans chacune. Ce mode vous permet de définir le prix des chambres pour les 10 prochaines années. <br/> Si vous utilisez les modes de modification de tarif Avancé ou Micromanage, vous pouvez définir le prix des chambres jour par jour pour les années à venir. Vous pouvez également avoir plusieurs tarifs pour le même type de chambre ; par exemple, vous pouvez avoir un tarif pour le lit + le petit-déjeuner et un autre pour le lit + le petit-déjeuner + le dîner. À moins que vous n\'ayez un besoin spécifique, nous vous recommandons d\'utiliser le mode Avancé ou Micromanage Ce mode fonctionnera de la même manière, mais vous devrez veiller à ce que les dates de début et de fin de vos différents tarifs soient consécutives.');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_EXTRAS', 'Comment créer des extras ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_EXTRAS', 'Des extras peuvent être ajoutés aux réservations et sont configurables dans Paramètres > Extras. Ceux-ci peuvent être facultatifs ou forcés, autrement dit, le client ne peut pas les désélectionner lors de la réservation. Vous pouvez proposer différentes méthodes de facturation pour les extras : qu\'ils soient affichés ou non dans la page Descriptif de l\'établissement. Étant donné que les extras peuvent être uniquement saisonniers ou à des périodes limitées (par exemple, pour les fruits de saison ou une activité liée à la météo), vous devez vous assurer que vous avez défini des dates de validité avec début (De) et fin (à). Une fois que vous avez créé des extras, vous pouvez télécharger les images correspondantes via le Gestionnaire de médias.');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_PAYMENTS', 'Comment puis-je encaisser les paiements en ligne ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_PAYMENTS', 'Pour encaisser les paiements en ligne, vous devez disposer d\'un compte auprès d\'un fournisseur de paiement en ligne, appelé passerelle. Pour voir les passerelles de paiements disponibles, allez à l\'onglet Configuration des établissements > Passerelles de paiements. Cliquez sur le nom d\'une passerelle pour accéder à sa page de configuration.');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_DISCOUNTS', 'Puis-je faire des remises ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_DISCOUNTS', 'Des réductions peuvent être accordées, il y a un plusieurs façons de le faire. Si vous effectuez une réservation pour le compte d\'un client, vous pouvez définir vos propres acomptes et tarifs de réservations dans le formulaire de réservation, à l\'aide des champs Modifier le total de la réservation et Modifier l\'acompte (les clients ne peuvent pas utiliser cette fonctionnalité). Une autre façon de donner à un client une réduction est de créer des coupons de réduction, qui peuvent être configurés de manière à ne pouvoir être utilisés qu\'entre certaines dates (valable du / au) ou appliqués uniquement lorsque la réservation tombe entre certaines dates (réservation valable du / au ). Ces coupons de réduction peuvent être attribués à un seul client, ou si vous le souhaitez, vous pouvez imprimer les coupons. L\'impression comprend un code QR que les clients peuvent numériser sur leur téléphone et qui les dirige vers votre formulaire de réservation où le code de réduction sera appliqué.');
jr_define('_JOMRES_FAQ_MANAGER_CATEGORY_BOOKINGS', 'Réservations');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_BOOKINGS_CONTACTPAGE', 'Lorsque je clique sur Nouvelle réservation, je suis redirigé vers le formulaire de contact : pourquoi ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_BOOKINGS_CONTACTPAGE', 'Avant de pouvoir prendre des réservations en ligne, vous devez d\'abord configurer des tarifs pour chaque type de chambre que vous avez dans votre établissement. Une fois que vous avez créé des tarifs, vous pourrez prendre des réservations.');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_BOOKINGS_BLACK', 'Que sont les réservations noires (hors service - OOO : Out Of Order) ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_BOOKINGS_BLACK', 'Les réservations noires sont des réservations créées pour mettre une ou plusieurs chambres hors service. Ils ne sont associés à aucun invité et sont utilisées, par exemple, si une pièce doit être rénovée.');
jr_define('_JOMRES_FAQ_MANAGER_CATEGORY_IMAGES', 'Images');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_MEDIACENTRE_INTRO', 'Comment télécharger des images ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_MEDIACENTRE_INTRO', 'Pour télécharger des images, veuillez vous rendre sur l\'espace Paramètres > Gestion des médias. Sur cette page, vous verrez plusieurs panneaux. En haut, vous avez des notes et en dessous, vous verrez une liste déroulante. Cette liste déroulante vous permet de sélectionner la ressource pour laquelle vous téléchargez des images.<br/> Sur la droite se trouve une colonne avec Ajouter des images, Effacer la liste et Tout télécharger. Cliquez sur Ajouter des images et sélectionnez des images sur votre ordinateur de bureau ou votre appareil mobile. Lorsque vous avez terminé, la colonne devient une liste de vignettes. Vous pouvez aussi télécharger une ou plusieurs images pour vos ressources.');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_MEDIACENTRE_MAIN', 'Que veut dire Image principale ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_MEDIACENTRE_MAIN', 'L\'image principale est celle qui apparaît dans les résultats de recherche et dans l\'en-tête de la page de votre établissement. Vous devez choisir une image qui présente votre établissement de la meilleur façon possible. Pour télécharger une image principale, assurez-vous que la propriété Image principale est bien sélectionnée dans la liste déroulante en haut à gauche, puis téléchargez une ou plusieurs images. Si vous téléchargez plus d\'une image, toutes les images seront utilisées dans la page des résultats de la recherche sous la forme d\'un petit diaporama.');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_MEDIACENTRE_RESOURCEFEATURES', 'Que sont les icônes des équipements de chambres ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_MEDIACENTRE_RESOURCEFEATURES', 'Les équipements des chambres peuvent être créés par les administrateurs des modes d’édition des tarifs Micromanage ou Avancés. Ceux-ci peuvent être liés à une ou plusieurs chambres et sont affichés dans le formulaire de réservation. Une fois que vous avez créé un équipement de chambre, vous pouvez télécharger une image pour cette équipement en sélectionnant d\'abord les icônes d\'équipements de chambre dans le menu déroulant du Gestionnaire de Médias, puis en sélectionnant le nom de l\'équipement des chambres dans le menu déroulant qui apparaît en dessous.');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_MEDIACENTRE_ROOMS', 'Comment télécharger des images des chambres ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_MEDIACENTRE_RESOURCEFEATURES', 'Les chambres peuvent être créées par les utilisateurs des modes d’édition des tarifs Micromanage ou Avancés. Une fois qu\'une ou plusieurs chambres ont été créées, vous pouvez télécharger plusieurs images pour chaque chambre via le Gestionnaire des médias (sélectionnez le nom/le numéro de la chambre après avoir sélectionné Images des chambres dans le menu déroulant). Ces images peuvent être vues dans un diaporama en affichant la Prévisualisation/Aperçu, en sélectionnant l\'onglet Nos chambres, puis en cliquant sur le lien Disponibilité.');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_MEDIACENTRE_SLIDESHOW', 'Comment télécharger des images de diaporama ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_MEDIACENTRE_SLIDESHOW', 'Les images du diaporama sont visibles dans la page Descriptif de l\'établissement (Prévisualisation/Aperçu), à côté du bouton Réserver maintenant.');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_MEDIACENTRE_EXTRAS', 'Comment télécharger des images pour les extras ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_MEDIACENTRE_EXTRAS', 'La procédure est semblable aux chambres et aux équipements de la chambre, vous devez créer un extra en premier. Une fois que cela est fait, vous pouvez sélectionner Extras dans le menu déroulant supérieur. Ensuite, vous devez sélectionner le nom de l\'Extra dans la liste déroulante ci-dessous. Lorsque le nom est sélectionné, vous pouvez télécharger une ou plusieurs images pour cet extra.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_CURRENCIES_SETUP', 'Comment configurer les symboles des devises ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_CURRENCIES_SETUP', 'Vous ne pouvez pas ! Tous les symboles de devise sont déjà stockés dans le système et il appartient aux gestionnaires d\'établissements de sélectionner la devise qui leur convient dans la page Configuration de l\'établissement.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_CURRENCIES', 'Comment activer plusieurs devises ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_CURRENCIES', 'Jomres dispose d\'une fonctionnalité permettant de convertir automatiquement les prix d\'une devise à une autre. Vous devez d’abord allez sur l’onglet Configuration du site > Conversion de devises. Vous y trouverez des liens vers deux services en ligne. Le premier service, une fois l\'API enregistrée, permet à Jomres de télécharger quotidiennement les données de conversion de devises. La seconde active la géolocalisation basée sur l\'IP des utilisateurs. Demandez une clé API gratuite à chaque service. Grâce à ces deux services combinés, Jomres peut détecter la devise locale de l\'utilisateur et afficher les prix des établissements dans la devise locale de l\'internaute, ainsi que dans la devise de l\'établissement. Si vous ne configurez pas ces clés API, Jomres utilisera par défaut le symbole monétaire de l\'euro. Si vous le souhaitez, vous pouvez définir un code de devise global. Cela signifie que les gestionnaires d\'établissements (partenaires) ne pourront sélectionner aucune autre devise. Toutefois, les clients potentiels verront toujours les prix dans leur propre monnaie locale, à moins qu\'ils n\'aient utilisé la fonction de changement de devise sur le site pour changer la devise dans laquelle les prix sont affichés.');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_LANGUAGES', 'Comment enregistrer des descriptions dans plusieurs langues ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_LANGUAGES', 'Pour enregistrer les descriptions dans plusieurs langues, consultez d’abord la page Paramètres > Descriptif de l\'établissement. Enregistrez la description de votre établissement à cet endroit. Ensuite, modifiez la langue d\'affichage du site. Maintenant, accédez à nouveau à la page Paramètres > Descriptif de l\'établissement, puis enregistrez à nouveau votre etxte. Par exemple, le site est capable d\'afficher l\'anglais et l\'espagnol (ou toute autre langue). Pour cela, vous devez sélectionner l\'anglais, entrer la description en anglais, puis cliquer sur Enregistrer. Ensuite, changez la langue actuelle en espagnol, puis enregistrez la nouvelle description en espagnol. Cela fonctionne pour toutes les entrées sur cette page.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_PROPERTIES_NUMBER', 'Combien d\'établissements puis-je enregistrer ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_PROPERTIES_NUMBER', 'Il n\'y a pas de limitation au nombre d\'établissements, la seule limitation concerne la limitation physique de votre serveur. Si c\'est un serveur avec beaucoup d\'autres sites (mutualisé), alors les ressources seront limitées, si c\'est un serveur dédié ou virtuel dédié, alors vous pourrez enregistrer beaucoup d\'établissements.');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_OTHERPROPERTIES', 'Puis-je modifier d\'autres établissement sur le site ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_OTHERPROPERTIES', 'Non, vous ne pouvez pas ! Vous ne pouvez administrer que les établissements que vous avez créées ou auxquelles vous avez été affecté en tant que gestionnaire d\'établissement (partenaire).');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_OTHERPROPERTIES_SUPER', 'Puis-je quand même modifier d\'autres établissements sur ce site dans certains cas ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_OTHERPROPERTIES_SUPER', 'Oui ! Si vous êtes un Super Property Manager (super administrateur d\'établissements), vous pouvez modifier les établissements affichés dans la page Liste des établissements.');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_GUESTTYPES', 'Quels sont les types de clients ? Comment puis-je changer le tarif par personne et par nuit ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_GUESTTYPES', 'Dans Paramètres > Configuration des établissements > onglet Tarifs et Devises, vous pouvez décider si vous souhaitez facturer Par personne et par nuit. Si vous voulez chargez le paramètre Par personne et par nuit, vous devrez créer un ou plusieurs types de client. Vous pouvez créer un type de client simple, en leur donnant simplement une description (par exemple : Personnes) ou en créant plusieurs types de clients différents (par exemple : Adultes, Enfants de moins de 10 ans). Pour les enfants, si vous souhaitez offrir un rabais de 50 % par exemple, définissez l\'option En pourcentage sur Oui et la valeur sur 50. Les chambres ayant des tarifs de base, ce paramètre vous permet d\'ajuster le prix de la chambre sur le type de client.');
jr_define('_JOMRES_FAQ_MANAGER_QUESTION_ROOMFEATURES', 'Quels sont les équipements des chambres ?');
jr_define('_JOMRES_FAQ_MANAGER_ANSWER_ROOMFEATURES', 'Les équipements des chambres sont des éléments qui la distinguent. Cela peut être quelque chose de simple, comme un plateau ou une bouilloire, ou des choses qui la valorise vraiment, comme une Vues sur la baie. Une fois que vous avez créé un équipement de chambre, vous pouvez télécharger des images pour cet élément dans la Gestion des médias. Ces équipements de chambre peuvent être consultés sur la page de disponibilité des chambres. Si vous avez configuré votre établissement pour afficher le style de liste de chambres classiques (où les clients peuvent sélectionner exactement la chambre à réserver), ils peuvent utiliser les équipements de chambre pour filtrer la recherche des chambres dans le formulaire de réservation.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_INTRODUCTION_PROFILES', 'Puis-je faire d\'un utilisateur un gestionnaire d\'établissement ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_INTRODUCTION_PROFILES', 'Oui, vous pouvez ! Via la page Gestionnaires d\'établissement dans la Gestion des utilisateurs. Si l\'utilisateur est déjà enregistré, dans le champ en haut de la page Gestionnaires d\'établissement, tapez les premiers caractères du nom d\'utilisateur et le nom d\'utilisateur apparaîtra en dessous. Cliquez sur le nom d\'utilisateur et vous serez dirigé vers une page où vous pourrez configurer les établissement auxquels ils auront accès. S\'ils ne sont pas déjà enregistrés, ils devront s\'enregistrer via la page de connexion et de création de compte du CMS. <br/> <br/> Un conseil : si vous avez l\'intention d\'affecter un gestionnaire d\'établissement à d\'autres établissements sur votre site, que ce soit par le biais d’une prise de commission via la passerelle Stripe ou de la fonctionnalité abonnements/commissions, nous ne vous recommandons pas de procéder de cette manière. Seuls les supers gestionnaires d\'établissement doivent être ajoutés à l\'aide de ce processus et, lorsqu\'ils sont ajoutés, vous ne devez sélectionner aucune propriété dans la liste située en dessous. Tous les autres types de gestionnaire (partenaires) doivent créer eux-mêmes leur(s) établissement(s) avec leur compte dans leur espace dédié sur le site. Cela les ajoutera automatiquement en tant que gestionnaires d\'établissement et garantira que le bon partenaire/gestionnaire est facturé.');
jr_define('_JOMRES_FAQ_ADMIN_CATEGORY_PLUGINS', 'Plugins');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_GENERAL_PLUGINS', 'A quoi sert le Plugin Manager ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_GENERAL_PLUGINS', 'Le gestionnaire de plug-ins est un outil essentiel de Jomres. Il nous permet d\'obtenir la version la plus récente des plug-ins Jomres via une fonctionnalité de téléchargement et d\'installation automatique.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_GENERAL_PLUGINS_IONCUBE', 'Pourquoi un avertissement concernant Ioncube Loaders apparaît-il lorsque je vais sur la page Gestionnaire de plug-in ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_GENERAL_PLUGINS_IONCUBE', 'Vous avez enregistré une clé de licence d\'évaluation dans la configuration du site, mais votre serveur ne propose pas le dernier Ioncube Loaders. Veuillez demander à vos hébergeur ou votre administrateur réseau d\'installer cette extension serveur, qui se trouve <a href="http://www.ioncube.com/loaders.php target="_blank""> sur cette page. </a> Si vous avez acheté une licence complète ou un abonnement et que vous avez ce message d\'erreur, vous avez peut-être oublié d\'entrer votre clé de licence dans la configuration du site.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_GENERAL_PLUGINS_INSTALLATION', 'Comment installer un plugin ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_GENERAL_PLUGINS_INSTALLATION', 'En supposant que vous ayez un numéro de clé de licence valide enregistré dans la configuration du site, il vous suffit de cliquer sur le bouton Installer à coté du nom du plug-in dans le gestionnaire de plug-ins. Jomres installera le plug-in pour vous et vous ramènera à la page des plugins par la suite. De temps en temps, vous pourriez être amené à une page de découverte ou d\'informations, si vous utilisez Jomres dans Joomla. Cliquez simplement sur le bouton Découvrir pour installer le plug-in. <br/> <br/> ATTENTION ! N\'installez pas tous les plug-ins, ils ne fonctionnent pas tous ensemble (de par leur conception). Vous pourriez vous retrouver avec des pages vierges dans le formulaire de réservation. Au lieu de cela, identifiez les plugins dont vous avez besoin, et expérimentez-les.');
jr_define('_JOMRES_FAQ_ADMIN_CATEGORY_SITESTRUCTURE', 'Structure du site');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_SITESTRUCTURE_INTRO', 'Que signifie Structure du site ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_SITESTRUCTURE_INTRO', 'La structure du site dans Jomres fait référence aux différents éléments de votre site. Elle définit les types d\'établissements que vous proposer (villas, gîtes, villages ou hôtels, par exemple) et les types de chambres et les sous-catégories pour les différents types d\'établissements. Vous proposez des locations de chalets ou une villa : le nombre de chambres, de balcons, etc. peut varier d\'un hébergement à l\'autre. Dans le cas d\'hôtels ou de gîtes, vous louez des chambres dans l\'établissement, qui sont des chambres doubles, des chambres simples, etc. Pour vous aider, une installation par défaut, une structure de site, comporte déjà plusieurs pièces et types d\'établissement créés, et vous facilite l\'apprentissage. Si vous souhaitez vendre des activités ou des visites, n\'essayez pas de créer un nouveau type d\'établissement sans lire au préalable la section consacrée aux activités et visites.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_SITESTRUCTURE_PROPERTYTYPES', 'Qu\'est-ce qu\'un type d\'établissement ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_SITESTRUCTURE_PROPERTYTYPES', 'Dans ce logiciel, un type d\'établissement fait référence littéralement au type de propriété immobilière. Cela peut être un hôtel, une villa, un appartement, un gîte, un village, etc. Les gestionnaires d\'établissements ne peuvent pas créer de types d\'établissements, car les types d\'établissements sont la hiérarchie la plus haute dans laquelle les clients peuvent effectuer une recherche. Pour que votre fonctionnalité de recherche reste nette et ordonnée, seuls les administrateurs de site peuvent créer des types d\'établissement.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_SITESTRUCTURE_PROPERTYFEATURES', 'Quelles sont les équipements/caractéristiques d\'un établissement ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_SITESTRUCTURE_PROPERTYFEATURES', 'Les équipements/caractéristiques d\'un établissement sont des éléments qui rendent un établissement unique. Par exemple, une caractéristique d\'un établissement peut être Proche de la plage, tandis qu\'un autre établissement peut avoir la particularité d\'être à l\'intérieur d\'un parc national, d\'avoir une piscine intérieure ou extérieure, des allées cavalière pour les chevaux etc. Comme les types d\'établissements, les gestionnaires ne peuvent pas créer de nouvelles caractéristiques/équipements, ils peuvent uniquement sélectionner ceux que vous avez créées. Les caractéristiques d\'établissements peuvent avoir des images qui leur sont assignés. Vous devez d’abord télécharger des images par le biais de la liste déroulante Structure de site > Gestionnaire des médias > Icônes des équipements/caractéristiques d\'établissements. Téléchargez autant d’icônes que vous le souhaitez. Lorsque vous créez un établissement, vous pouvez choisir son image.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_SITESTRUCTURE_PROPERTYFEATURECATEGORIES', 'Que sont les catégories de caractéristiques d\'un établissement ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_SITESTRUCTURE_PROPERTYFEATURECATEGORIES', 'Les caractéristiques d\'un établissement sont affichées dans la page Descriptif de l\'établissement, entre autres. Sur la page descriptif de l\'établissement, les caractéristiques peuvent être affichés et regroupés par catégories, par exemple Surface habitable, Accessibilité, etc.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_SITESTRUCTURE_ROOMFEATURES', 'Quels sont les équipements/caractéristiques d\'une chambre ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_SITESTRUCTURE_ROOMFEATURES', 'Les gestionnaires de biens (Property Managers) qui utilisent le mode d\’édition des tarifs Micromanage ou Avancé peuvent modifier directement leurs chambres. Ils sont également capables de créer des éléments appelés caractéristiques/équipements de chambres, qui sont affichés dans la page de disponibilité de l\'hébergement pour chaque établissement. S\'ils utilisent l\'affichage de la liste des chambres classiques dans le formulaire de réservation, les clients peuvent utiliser les carcatéristiques de la chambre pour filtrer les chambres avant de sélectionner une ou plusieurs personnes. Sur la page Structure du site > Équipements des chambres, les responsables de site peuvent également créer des caractéristiques de chambre. Celles-ci sont visibles dans tous les formulaires de réservation de l\'établissement lorsque l\'établissement utilise la liste des chambres classiques. De base, il s’agit d’une fonctionnalité des caractéristiques généraux d\'une chambre. Ils peuvent être configurées pour ne s\'afficher que sur certains types d\'établissements. Les images de ces caractéristiques/équipements de chambre peuvent être téléchargées via la page Structure du site > Gestionnaire des médias.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_SITESTRUCTURE_COUNTRIES', 'Pourquoi y a-t-il une page pour modifier les pays et les régions ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_SITESTRUCTURE_COUNTRIES', 'Vous pensez qu\'une liste de pays est immuable... Au fil des années, en maintenant à jour une liste de pays, nous avons assisté à de nombreux changements. En conséquence, nous avons appris qu\'il est plus facile de permettre aux gestionnaires de site de définir les pays qu\'ils souhaitent afficher sur leur site. Cela permet aux Catalans (par exemple) d\'afficher leur province comme un pays unique, si c\'est ce qu\'ils souhaitent. La même chose vaut pour les autres régions du monde.');
jr_define('_JOMRES_FAQ_ADMIN_CATEGORY_LOCALISATION', 'Localisation des traductions');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_LOCALISATION_INTRO', 'Comment puis-je faire des traductions ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_LOCALISATION_INTRO', 'La traduction des étiquettes ou des chaînes de caractères se fait via les options du menu Langues, principalement les pages de traduction des fichiers de langue. Comme les fichiers de langue sont très volumineux, le chargement de celui-ci peut prendre un certain temps lorsque vous cliquez sur cette page. <br/> <br/> Prenons un exemple. Disons que vous voulez traduire l\'anglais en français. Cliquez d\'abord sur Traductions locales (Translate Locales). Ensuite, vérifiez le menu déroulant des langues en haut à droite de l\'anglais vers le français. Ensuite, faites défiler la page jusqu\'à l\'anglais. Vous pouvez voir qu\'il a un soulignement en pointillé. Cela signifie que vous pouvez le traduire. Cliquez sur le mot, vous verrez une fenêtre contenant le mot Translation. Changez cela en Traduction et cliquez sur la coche verte. Si votre CMS est configuré pour offrir des pages en français aux visiteurs du site, le mot Translation apparaîtra alors comme Traduction. Ce concept s\'applique tout au long de Jomres. <br/> <br/> Sur les pages du gestionnaire d\'établissement, les gestionnaires d\'établissement peuvent voir un menu déroulant Mode d\'édition des étiquettes en haut de leurs pages. Lorsque ce paramètre est défini sur Activé, ils pourront également apporter des modifications à l’interface client. Toutefois, ces modifications n’affecteront que leur établissement activé/validé. Ainsi, par exemple, ils peuvent facilement changer le mot Translation en Traduction donc pour leur établissement.');
jr_define('_JOMRES_FAQ_ADMIN_CATEGORY_TOURS', 'Activités/Visites');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_TOURS_INTRO', 'Qu\'est ce qu\'une activité/visite (tour) ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_TOURS_INTRO', 'Cela peut sembler une question idiote, mais en fait ce n’est pas le cas ! Au fil des ans, nous avons appris que différentes cultures ont des perceptions différentes de ce qu\'est un Tour/Activité/Visite. En conséquence, les attentes en matière de vente de Tour/Activité/Visite varient énormément. Avant de discuter des Tours/Activités/Visites, nous définirons d\'abord ce que nous en pensons. <br/> un(e)Tour/Activité/Visite est un simple voyage, une sortie sportive ou culturelle ou une visite pour voir une attraction ou un monument, ou pratiquer une activité en dehors de l\'établissemnt. Un séjour dans un hôtel n\'est pas une activité, mais vous pouvez participer à des activités durant votre séjour dans un hôtel.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_TOURS_HOWTOSELL', 'Comment utiliser Jomres pour vendre des activités ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_TOURS_HOWTOSELL', 'Pour mettre en vente des activités dans Jomres, vous devez d’abord installer le plugin Jintour. Ce plugin vous permet de créer des activités qui sont vendues dans le cadre de réservations. Il vous permet également de créer des établissements exclusivement destinées à la vente d\'activités. Une fois ce plugin installé, les gestionnaires d\'établissements pourront créer des activités et caractéristiques d\'activité dans l’interface.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_TOURS_WHATISJINTOUR', 'Qu\'est-ce que le plugin Jintour ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_TOURS_WHATISJINTOUR', 'Jintour est synonyme de Jomres INtegrated TOURs. Il vous permet de créer des activités simples et limitées pouvant être réservées, et qui ne sont pas des chambres d\'un établissement. Bien que le plugin soit conçu principalement pour permettre la réservation de visites, il peut être utilisé pour des activités diverses. Il peut être utilisé, par exemple, pour la location de skis et de matériels, ou des sorties en cheval, ou autres activités sportives ou culturelles, etc. Comme ces activités ont une disponibilité limitée dans le temps, vous pouvez utiliser le plugin Jintour pour permettre aux clients de les réserver et de les payer au moment de la réservation.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_TOURS_SAMEBOOKING', 'Comment puis-je vendre des visites et des locations de séjours dans la même réservation ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_TOURS_SAMEBOOKING', 'Dans ce scénario à titre d\'exemple, vous avez un établissement et vous souhaitez vendre des visites pour une attraction locale. Connectez-vous à l\'interface et allez à l\'établissement que vous avez créé. Ensuite, cliquez sur Paramètres > Gestion des activités. Sur cette page, suivez les instructions à l’écran pour créer d’abord un type de visite/activité, puis générer les. Une fois que cela est fait, vous pourrez vendre les visites guidées et les réservations de chambres et les extras côte à côte dans le même formulaire de réservation.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_TOURS_STANDALONETOURS', 'What about if I only want to sell tours?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_TOURS_STANDALONETOURS', 'TEn prmier, vous devrez créer un nouvel établissement depuis le site. Lorsque vous le faites, assurez-vous de définir le type d\'établissement pour l\'activité/visite. Une fois que vous avez créé cet nouvel établissement, vous pourrez à nouveau créer des activité/visites via la page Paramètres > Gestion des visites/activités. Vous pourrez également proposer des extras supplémentaires, comme dans les établissements normaux. La seule chose que vous ne pourrez pas faire est de configurer les chambres, les équipements des chambres ou les tarifs, car vous ne louer pas de chambre dans cet établissement.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_TOURS_GLOBALTOURS', 'Comment puis-je créer et vendre une activité qui peut être vue dans tous les formulaires de réservation ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_TOURS_GLOBALTOURS', 'Dans la zone d\'administration de votre site, visitez la page Portail > Gestion des activité. Le processus de génération est le même que celui utilisé sur le site directement ; les activités générées ici sont vues aussi depuis le site. Comme exemple, on peut envisager qu\'un administrateur d\'établissement organise des événements dans tout le pays où se trouve son établissement et qu\'il souhaite aussi louer en même temps des chambres de son hôtel. Il crée normalement l\'hôtel qui propose cette activité sur le site, en fixant les prix des chambres, etc. L\'utilisation de la Gestion d\'activités sera donc les frais de participation pour l\'événement lui-même, en plus de la réservation.');
jr_define('_JOMRES_FAQ_ADMIN_QUESTION_INTRODUCTION_FIRSTTHINGSFIRST', 'Ok, j\'ai installé Jomres, et ensuite ?');
jr_define('_JOMRES_FAQ_ADMIN_ANSWER_INTRODUCTION_FIRSTTHINGSFIRST', 'La toute première chose que vous devez faire, maintenant que vous avez installé Jomres, est de cliquer sur Aide dans le menu de gauche, puis sur Commencer votre découverte du logiciel.');
